#!/usr/bin/env bash
function info() {
    echo -e "\033[00;34mi\033[0m $1"
}

function success() {
    echo -e "\r\033[00;32m✓\033[0m $1"
}

function fail() {
    echo -e "\033[00;31m!\033[0m $1"
    exit 1
}

check() {
    if [[ $? != 0 ]]; then
        fail "$1"
        exit 1
    fi
}

info "Pulling latest project version"
git pull --quiet origin master
check "Could not pull latest project version"

info "Creating dist archive"
tar zcf dist.tar.gz src vendor public templates config_sample.php
check "Could not create dist archive"

info "Copying dist archive"
scp -q ./dist.tar.gz app@rlcms:~
check "Could not copy dist archive"

info "Replacing old dist"
ssh app@rlcms "cd /home/app &&
    mkdir -p rlads &&
    rm -rf rlads/src rlads/vendor rlads/public rlads/templates &&
    tar zxf ./dist.tar.gz -C rlads &&
    rm ./dist.tar.gz"
check "Could not replace old dist"

info "Deleting dist archive"
rm ./dist.tar.gz
check "Could not delete dist archive"

success "Project successfully deployed"
