<?php
// DIC configuration

$container = $app->getContainer();

// view renderer
$container['renderer'] = function ($c) {
    $settings = $c->get('settings')['renderer'];
    return new Slim\Views\PhpRenderer($settings['template_path']);
};

// monolog
$container['logger'] = function ($c) {
    $settings = $c->get('settings')['logger'];
    $logger = new Monolog\Logger($settings['name']);
    $logger->pushProcessor(new Monolog\Processor\UidProcessor());
    $logger->pushHandler(new Monolog\Handler\StreamHandler($settings['path'], Monolog\Logger::DEBUG));
    return $logger;
};

// flash messages
$container['flash'] = function () {
    return new \Slim\Flash\Messages();
};

// slim session helper
$container['session'] = function ($c) {
    return new \SlimSession\Helper;
};

// aura db builder
$container['db'] = function($c) {
    $settings = $c->get('settings');
    $pdo = new Aura\Sql\ExtendedPdo(
        'mysql:host='.$settings['db']['host'].';dbname='.$settings['db']['dbname'],
        $settings['db']['user'],
        $settings['db']['password']
    );
    return $pdo;
};

$container['jenuPublication'] = function($c){
    return $c->get('settings')['jenuPublication'];
};

