package session

import (
	"testing"
	"time"
)

type (
	sData struct {
		user int
	}
)

func TestRandomness(t *testing.T) {
	max := 1000
	sessions := make(map[int]string)
	for i := 0; i < max; i++ {
		sessions[i] = newRandomId()
		for j := 0; j < i; j++ {
			if sessions[i] == sessions[j] {
				t.Errorf("Duplicate session id found ")
			}
		}
	}
}

func TestExire(t *testing.T) {
	ses := New()
	ses.expire = nil
	if ses.expired() == true {
		t.Errorf("Expected to not be expired")
	}
	nexp := time.Now().Truncate(3 * time.Second)
	ses.expire = &nexp
	if ses.expired() == false {
		t.Errorf("Expected be expired")
	}
}

func TestToken(t *testing.T) {
	s1 := New()
	if s1.Token() == "" {
		t.Errorf("No token?")
	}
	old := s1.Token()
	// Validate token
	if s1.Validate(old) == false {
		t.Errorf("Invalid token 1 ?")
	}
	// Token refresh
	if s1.Token() == old {
		t.Errorf("Same token?")
	}
	// Revalidate old token
	if s1.Validate(old) == true {
		t.Errorf("Same old token?")
	}
	Set(s1)
	s2 := Get(s1.Id())
	if s2.Validate(s2.Token()) != true {
		t.Errorf("Invalid token 2 ?")
	}
	// Read from Session again
	s3 := Get(s2.Id())
	if s3.Token() != s2.Token() {
		t.Errorf("Storage issue Invalid token 2 ?")
	}

	if s2.Validate(s3.Token()) == false {
		t.Errorf("Storage issue Invalid token 3 ?")
	}

	if s3.Token() != s2.Token() {
		t.Errorf("Storage issue Invalid token 2 ?")
	}
}

func TestStorage(t *testing.T) {
	s1 := New()

	SetExpire(1)

	if Get("") != nil {
		t.Errorf("Storage for empy session ?")
	}

	if Get(s1.Id()) != nil {
		t.Errorf("Allready in storage ?")
	}
	Set(s1)
	if Get(s1.Id()) == nil {
		t.Errorf("Missing from storage ?")
	}
	s1.Data = &sData{
		user: 100,
	}
	Set(s1)
	data := Get(s1.Id()).Data.(*sData)
	if data.user != 100 {
		t.Errorf("Invalid data")
	}
	// Force Expire
	nexp := time.Now().Truncate(3 * time.Second)
	std.sessions[s1.Id()].expire = &nexp

	if Get(s1.Id()) != nil {
		t.Errorf("Session not expired ?")
	}

	s2 := New()
	Set(s2)
	s3 := New()
	Set(s3)
	s4 := New()
	Set(s4)

	// Set Expire
	s3exp := time.Now().Truncate(3 * time.Second)
	std.sessions[s3.Id()].expire = &s3exp

	std.sessiongc()
	//time.Sleep(10 * time.Second)
}
