package logger

import (
	"bytes"
	"encoding/json"
	"fmt"
)

func (f *LogFormatter) Format(entry *Entry) ([]byte, error) {

	timestampFormat := f.TimestampFormat
	if timestampFormat == "" {
		timestampFormat = DefaultTimestampFormat
	}
	b := &bytes.Buffer{}

	fmt.Fprintf(b, "%s %s:%d [%s] \"%s\"",
		entry.Time.Format(timestampFormat),
		entry.File,
		entry.Line,
		entry.Level.String(),
		entry.Message,
	)

	b.WriteByte('\n')
	return b.Bytes(), nil
}

func (f *JSONFormatter) Format(entry *Entry) ([]byte, error) {
	data := make(Fields, 3)

	timestampFormat := f.TimestampFormat
	if timestampFormat == "" {
		timestampFormat = DefaultTimestampFormat
	}

	data["time"] = entry.Time.Format(timestampFormat)
	data["msg"] = entry.Message
	data["level"] = entry.Level.String()

	serialized, err := json.Marshal(data)
	if err != nil {
		return nil, fmt.Errorf("Failed to marshal fields to JSON, %v", err)
	}
	return append(serialized, '\n'), nil
}
