package main

import (
	//	log "os/logger"
	"strconv"
	"strings"
	"time"
)

// Speed to Deciamal
// speed = float(speed)*1.852
//strconv.FormatFloat(input_num, 'f', 6, 64)

// Degree to Decimal
func ToDecimalDegrees(minute, seconds string) (float64, error) {
	min, err := strconv.ParseFloat(minute, 64)
	if err != nil {
		return float64(0), err
	}
	sec, err := strconv.ParseFloat(seconds, 64)
	if err != nil {
		return min, err
	}
	// Format to 6 char precision
	format := strconv.FormatFloat(min+sec/60, 'f', 6, 64)
	decimal, err := strconv.ParseFloat(format, 64)
	if err != nil {
		return min, err
	}
	return decimal, nil
}

// Convert To Decimal
func ToDecimal(speed string) (float64, error) {
	s, err := strconv.ParseFloat(speed, 64)
	if err != nil {
		return float64(0), err
	}
	return s, nil
}

func ParseDate(date string) (time.Time, error) {
	dstr := strings.Split(date, "-")

	loc, err := time.LoadLocation("Europe/Bucharest")
	if err != nil {
		return time.Now(), err
	}
	year, err := strconv.ParseInt(dstr[0], 10, 64)
	if err != nil {
		//return , err
	}
	month, err := strconv.ParseInt(dstr[1], 10, 64)
	if err != nil {
		//return , err
	}

	day, err := strconv.ParseInt(dstr[2], 10, 64)
	if err != nil {
		//return , err
	}

	return time.Date(int(year), time.Month(month), int(day), 0, 0, 0, 0, loc), nil
}

// Format Time
func FormatTimeShort(yy, mm, dd, h, m, s string) (time.Time, error) {
	year, err := strconv.ParseInt("20"+yy, 10, 64)
	if err != nil {
		//return , err
	}
	month, err := strconv.ParseInt(mm, 10, 64)
	if err != nil {
		//return , err
	}
	day, err := strconv.ParseInt(dd, 10, 64)
	if err != nil {
		//return , err
	}
	hour, err := strconv.ParseInt(h, 10, 64)
	if err != nil {
		//return , err
	}
	minute, err := strconv.ParseInt(m, 10, 64)
	if err != nil {
		//return , err
	}
	second, err := strconv.ParseInt(s, 10, 64)
	if err != nil {
		//return , err
	}

	t := time.Date(
		int(year),
		time.Month(int(month)),
		int(day),
		int(hour),
		int(minute),
		int(second),
		0,
		time.UTC).Add(time.Hour)

	return t, nil
}
