package main

import (
	"bufio"
	"os"
)

func parse_logfile(file string) error {
	fd, err := os.Open(file)
	if err != nil {
		return err
	}
	defer fd.Close()

	scanner := bufio.NewScanner(fd)
	scanner.Split(bufio.ScanLines)
	adapter := &TK103{}
	adapter.onPing = parseonPing
	for scanner.Scan() {
		line := scanner.Text()
		line = line[44 : len(line)-1]
		if line[:7] == "Message" {
			data := line[9:]
			adapter.Handle(data)
		}
	}
	return nil
}

func parseonPing(devstring string, event EventData) {

	if event.Active {
		if event.Latitude > 0 && event.Longitude > 0 {
			logdata := &Log{
				Time:      event.Time,
				Did:       1,
				Active:    true,
				Latitude:  event.Latitude,
				Longitude: event.Longitude,
				Speed:     int(event.Speed),
				Angle:     event.Angle,
			}
			server.db.Create(&logdata)
		}
	}
}
