package main

import (
	//	log "os/logger"
	"math"
	"strconv"
	"strings"
	"time"
)

// Speed to Deciamal
// speed = float(speed)*1.852
//strconv.FormatFloat(input_num, 'f', 6, 64)

// Degree to Decimal
func ToDecimalDegrees(minute, seconds string) (float64, error) {
	min, err := strconv.ParseFloat(minute, 64)
	if err != nil {
		return float64(0), err
	}
	sec, err := strconv.ParseFloat(seconds, 64)
	if err != nil {
		return min, err
	}
	// Format to 6 char precision
	format := strconv.FormatFloat(min+sec/60, 'f', 6, 64)
	decimal, err := strconv.ParseFloat(format, 64)
	if err != nil {
		return min, err
	}
	return decimal, nil
}

// Convert To Decimal
func ToDecimal(speed string) (float64, error) {
	s, err := strconv.ParseFloat(speed, 64)
	if err != nil {
		return float64(0), err
	}
	return s, nil
}

func ParseDate(date string) (time.Time, error) {
	dstr := strings.Split(date, "-")

	loc, err := time.LoadLocation("Europe/Bucharest")
	if err != nil {
		return time.Now(), err
	}
	year, err := strconv.ParseInt(dstr[0], 10, 64)
	if err != nil {
		//return , err
	}
	month, err := strconv.ParseInt(dstr[1], 10, 64)
	if err != nil {
		//return , err
	}

	day, err := strconv.ParseInt(dstr[2], 10, 64)
	if err != nil {
		//return , err
	}

	return time.Date(int(year), time.Month(month), int(day), 0, 0, 0, 0, loc), nil
}

// Format Time
func FormatTimeShort(yy, mm, dd, h, m, s string) (time.Time, error) {
	year, err := strconv.ParseInt("20"+yy, 10, 64)
	if err != nil {
		//return , err
	}
	month, err := strconv.ParseInt(mm, 10, 64)
	if err != nil {
		//return , err
	}
	day, err := strconv.ParseInt(dd, 10, 64)
	if err != nil {
		//return , err
	}
	hour, err := strconv.ParseInt(h, 10, 64)
	if err != nil {
		//return , err
	}
	minute, err := strconv.ParseInt(m, 10, 64)
	if err != nil {
		//return , err
	}
	second, err := strconv.ParseInt(s, 10, 64)
	if err != nil {
		//return , err
	}

	t := time.Date(
		int(year),
		time.Month(int(month)),
		int(day),
		int(hour),
		int(minute),
		int(second),
		0,
		time.UTC)

	return t, nil
}

// haversin(θ) function
func hsin(theta float64) float64 {
	return math.Pow(math.Sin(theta/2), 2)
}

// Distance function returns the distance (in meters) between two points of
//     a given longitude and latitude relatively accurately (using a spherical
//     approximation of the Earth) through the Haversin Distance Formula for
//     great arc distance on a sphere with accuracy for small distances
//
// point coordinates are supplied in degrees and converted into rad. in the func
//
// distance returned is METERS!!!!!!
// http://en.wikipedia.org/wiki/Haversine_formula

func Distance(lat1, lon1, lat2, lon2 float64) float64 {
	var la1, lo1, la2, lo2, r float64
	la1 = lat1 * math.Pi / 180
	lo1 = lon1 * math.Pi / 180
	la2 = lat2 * math.Pi / 180
	lo2 = lon2 * math.Pi / 180
	r = 6378100 // Earth radius in METERS
	// calculate
	h := hsin(la2-la1) + math.Cos(la1)*math.Cos(la2)*hsin(lo2-lo1)
	return 2 * r * math.Asin(math.Sqrt(h))
}
