package main

import (
	"html/template"
	"io"
	"sync"

	//	log "os/logger"
)

type (
	PageData struct {
		Title   string
		JS      []string
		CSS     []string
		Content interface{}
	}
	HTML struct {
		pages map[string]*template.Template
		m     sync.Mutex
	}
)

func NewHTML() *HTML {
	return &HTML{
		pages: make(map[string]*template.Template),
	}
}

func NewPage(title string, data interface{}) *PageData {
	return &PageData{
		Title: title,
		CSS: []string{
			"//maxcdn.bootstrapcdn.com/bootstrap/3.2.0/css/bootstrap.min.css",
			"//maxcdn.bootstrapcdn.com/bootstrap/3.2.0/css/bootstrap-theme.min.css",
			"/assets/css/main.css",
		},
		Content: data,
	}
}

func (p *PageData) AddJS(name string) *PageData {
	p.JS = append(p.JS, name)
	return p
}

func (t *HTML) Execute(name string, w io.Writer, data *PageData) error {
	t.m.Lock()
	page, found := t.pages[name]
	t.m.Unlock()

	// New session or session expired
	if !found {
		var err error
		page, err = t.load(name)
		if err != nil {
			return err
		}
	}
	page.ExecuteTemplate(w, "layout", data)
	return nil
}

// Load Template and Cache it
func (t *HTML) load(name string) (*template.Template, error) {
	page, err := template.ParseFiles(
		t.file("layout.html"),
		t.file("views/"+name+".html"),
	)
	if err != nil {
		return nil, err
	}
	t.m.Lock()
	t.pages[name] = page
	t.m.Unlock()
	return page, nil
}

func (t *HTML) file(name string) string {
	fullpath := server.c.http_root + name
	return fullpath
}
