package main

import (
	"net/httpd"
	"net/httpd/session"
	log "os/logger"
	"time"
)

func doLogin(username, password string) (*Session, bool) {
	user := &User{}
	server.db.Where("name = ? and password = ?", username, password).First(&user)
	log.Printf("db : %x ", user)
	if user.Id == 0 {
		return nil, false
	} else {

		return &Session{
			user: user.Name,
		}, true
	}
}

func AuthHandler(next httpd.Handler) httpd.Handler {
	return httpd.HandlerFunc(func(c *httpd.Context) {
		log.Printf("USER auth handler requested !")

		s, err := c.Request.Cookie(sidname)
		if err != nil {
			//Setup new Session
			ses := session.New()
			session.Set(ses)
			c.SetCookie(sidname, ses.Id(), sidexpire)
			c.Redirect("/login", 302)
			return
		}

		ses := session.Get(s.Value)
		if ses == nil {
			ses := session.New()
			session.Set(ses)
			c.SetCookie(sidname, ses.Id(), sidexpire)
			c.Redirect("/login", 302)
			return
		}

		// Handle login
		if c.RequestURI == "/login" && c.RequestMethod == "POST" {
			usr := c.Request.FormValue("username")
			pwd := c.Request.FormValue("password")
			sdata, login := doLogin(usr, pwd)
			if login == false {
				c.Redirect("/login", 302)
				return
			}
			// Store the session
			ses.Data = sdata
			session.Set(ses)
			c.Redirect("/", 302)
			return
		}

		if ses.Data == nil && c.RequestURI != "/login" {
			c.Redirect("/login", 302)
			return
		}
		c.Session = ses

		next.Handle(c)
	})
}

func indexPage(c *httpd.Context) {

	data := struct {
		Test       string
		LogEvents  []string
		ProxyTotal int64
	}{}

	//SELECT DATE_FORMAT(`time`, '%Y-%m-%d') FROM `logs` WHERE 1 GROUP BY DATE_FORMAT(`time`,'%Y%m%d')
	rows, err := server.db.Raw("SELECT DATE_FORMAT(`time`, '%Y-%m-%d')  FROM `logs` WHERE 1 GROUP BY DATE_FORMAT( `time` , '%Y%m%d' ) ").Rows()
	if err != nil {
		log.Errorf("%s", err)
		return
	}
	defer rows.Close()
	for rows.Next() {
		tm := ""
		rows.Scan(&tm)
		data.LogEvents = append(data.LogEvents, tm)
	}

	// Setup new Page
	page := NewPage("Real Time GPS Tracker", data)
	page.AddJS("https://maps.googleapis.com/maps/api/js?key=AIzaSyBn7yp_UcuCe5U1IZHKcfyJ5wJTMS8YIIM")
	page.AddJS("https://ajax.googleapis.com/ajax/libs/jquery/2.1.4/jquery.min.js")
	html.Execute("index",
		c.Response,
		page,
	)
}

func loginPage(c *httpd.Context) {
	err := html.Execute(
		"login",
		c.Response,
		NewPage("Login", nil),
	)
	if err != nil {
		log.Error(err)
	}
}

// Track device
func trackHandler(c *httpd.Context) {
	var logs []Log

	device := c.Param("device")
	date, err := ParseDate(c.Param("date"))
	if err != nil {
		log.Printf("trackHandler error parsing time %s", err)
		c.Error("Invalid date", 400)
		return
	}
	log := &Log{Time: date}
	server.db.Order("time asc").Where("did = ? AND time > ? AND time < ? ", device, log.Time, log.Time.Add(24*time.Hour)).Find(&logs)

	c.JSON(200, logs)
}

// Logout
func logoutPage(c *httpd.Context) {
	sess := c.Session.(*session.Session)
	sess.Data = nil
	session.Set(sess)

	log.Printf("logging out from sid %s", sess.Id())

	c.Redirect("/login", 302)

}

// GPSD ROUTER
func gpsd_router() (*httpd.Router, error) {
	http := httpd.NewRouter()
	http.BeforeHandle(AuthHandler)
	http.Get("/", indexPage)

	http.Get("/track/:device/:date", trackHandler)
	http.Get("/login", loginPage)
	http.Get("/logout", logoutPage)
	// Assets Handlers

	assets := http.Subrouter("/assets")
	/*
		pwd, err := os.Getwd()
		if err != nil {
			//fmt.Println(err)
			os.Exit(1)
		}
	*/

	assets.ServeFiles("/*filepath", server.c.http_root+"assets/")

	return http, nil
}
