package main

import (
	"errors"
	"net"
)

// Device Helpers
func (d *TDeviceInfo) Handle(msg string) error {
	return d.adapter.Handle(msg)
}

func (d *TDeviceInfo) onLogin(handler LoginHandler) {
	d.adapter.OnLogin(handler)
}

func (d *TDeviceInfo) onAlarm(handler EventHandler) {
	d.adapter.OnAlarm(handler)
}

func (d *TDeviceInfo) onPing(handler EventHandler) {
	d.adapter.OnPing(handler)
}

// Define all Known Parsers
func GetDeviceAdapter(msg string, conn net.Conn) (*TDeviceInfo, error) {
	// TK102
	if msg[:1] == "(" && msg[len(msg)-1:] == ")" {
		if len(msg) > 13 && msg[13:14] == "B" {
			device := &TDeviceInfo{
				Id:      msg[1:13],
				IpAddr:  conn.RemoteAddr().String(),
				adapter: &TK103{c: conn},
			}

			return device, nil
		}
	}

	return nil, errors.New("GetDeviceAdapter: No Adapter found")
}
