package main

import (
	"fmt"
	"util/cfg"
)

//
// Server Configuration
//

type GPSServerConfig struct { // GPS Server Config
	cfgfile   string
	db_user   string
	db_pass   string
	db_host   string
	db_port   int
	db_db     string
	http_addr string
	http_port int64
	http_root string
}

// Load and parse config File
func (c *GPSServerConfig) LoadConfig() error {

	conf, err := cfg.ReadFile(c.cfgfile)
	if err != nil {
		return err
	}

	if conf.HasOption("database", "hostname") {
		c.db_host, err = conf.GetString("database", "hostname")
	}

	if conf.HasOption("database", "database") {
		c.db_db, err = conf.GetString("database", "database")
	}

	if conf.HasOption("database", "username") {
		c.db_user, err = conf.GetString("database", "username")
	}

	if conf.HasOption("database", "password") {
		c.db_pass, err = conf.GetString("database", "password")
	}

	if conf.HasOption("server", "address") {
		c.http_addr, err = conf.GetString("server", "address")
	}

	if conf.HasOption("server", "port") {
		c.http_port, err = conf.GetInt64("server", "port")
	}

	if conf.HasOption("server", "httpdocs") {
		c.http_root, err = conf.GetString("server", "httpdocs")
	}
	return nil
}

func (c *GPSServerConfig) httpAddr() string {
	return fmt.Sprintf("%s:%d", c.http_addr, c.http_port)
}

func (c *GPSServerConfig) DbString() string {
	return fmt.Sprintf("%s:%s@tcp(%s:%d)/%s?charset=utf8&parseTime=true",
		c.db_user,
		c.db_pass,
		c.db_host,
		c.db_port,
		c.db_db,
	)
}
