package cluster

import (
	"log"
	"os"
	"sync"
	"testing"
	"time"
)

func TestHealtyInterval(t *testing.T) {
	hafreq := 10
	cluster := &Cluster{
		heartbeatFrequency: hafreq,
		optlock:            new(sync.RWMutex),
	}
	haInterval := time.Duration(hafreq) * time.Second
	if cluster.getHealthyInterval() != haInterval {
		t.Fatalf("Invalid Heartbeat HealtyInterval")
	}
}

func TestNewPeer(t *testing.T) {
	var err error

	_, err = NewPeer("test", "testing", "127.0.0.256:0")
	if err == nil {
		t.Fatalf("Invalid address accepted (1)")
	}

	_, err = NewPeer("test", "testing", "127.0.0.256:60000")
	if err == nil {
		t.Fatalf("Invalid address accepted (2)")
	}

}

func TestAcceptRoutine(t *testing.T) {

}

func TestPerrsByDomain(t *testing.T) {
	var peer *Peer

	// Generate new PeerId
	selfpeer, err := NewPeer("test", "testing", "127.0.0.1:0")
	if err != nil {
		t.Error(err)
	}
	cluster := &Cluster{
		self:      selfpeer,
		peers:     make(map[int64]Peer),
		peerslock: new(sync.RWMutex),
	}

	peer, _ = NewPeer("test1", "test", "127.0.0.1:10")
	cluster.peers[peer.Id] = *peer

	peer, _ = NewPeer("test2", "test", "127.0.0.1:20")
	cluster.peers[peer.Id] = *peer

	peer, _ = NewPeer("test2", "local", "127.0.0.1:20")
	cluster.peers[peer.Id] = *peer

	peers := cluster.getPeersByDomain("test")
	if len(peers) != 2 {
		t.Fatalf("We expect to find 2 peers in domain test")
	}

	peers = cluster.getPeersByDomain("local")
	if len(peers) != 1 {
		t.Fatalf("We expect to find 1 peer in domain local")
	}

	peers = cluster.GetPeers()
	if len(peers) != 3 {
		t.Fatalf("We expect to find 3 peers in total")
	}

}

func TestDebuging(t *testing.T) {

	// Generate new PeerId
	selfpeer, err := NewPeer("test", "testing", "127.0.0.1:0")
	if err != nil {
		t.Error(err)
	}

	cluster := &Cluster{
		self:     selfpeer,
		optlock:  new(sync.RWMutex),
		logLevel: LogLevelDebug,
		log:      log.New(os.Stdout, "", log.LstdFlags),
	}

	cluster.debug("Debug message")
	cluster.warn("Warn message")
	cluster.err("Error message")
}
