package cluster

import (
	"bytes"
	"testing"
)

type Msg1 struct {
	Field1 string
	Field2 string
	field3 string
}

var from int64 = 1000
var to int64 = 1001
var mtype int8 = 1

func TestEncodeTypes(t *testing.T) {

	var err error

	type msg2 struct{ field1 string }

	reader := new(bytes.Buffer)
	enc := newEncoder(reader)
	err = enc.Encode(from, to, mtype, []byte("adasd"))
	if err != nil {
		t.Fatalf("Error encoding message %s", err)
	}

	err = enc.Encode(from, to, mtype, "adasd")
	if err != nil {
		t.Fatalf("Error encoding message %s", err)
	}

	err = enc.Encode(from, to, mtype, nil)
	if err != nil {
		t.Fatalf("Error encoding message %s", err)
	}

	err = enc.Encode(from, to, mtype, &msg2{})
	if err == nil {
		t.Fatalf("Gob encoding did not sent any error!", err)
	}

}

func TestEncodeDecode(t *testing.T) {

	var err error

	reader := new(bytes.Buffer)
	enc := newEncoder(reader)

	data := &Msg1{
		Field1: "test1",
		Field2: "test2",
		field3: "test3",
	}
	err = enc.Encode(from, to, mtype, data)

	if err != nil {
		t.Fatalf("Error encoding message %s", err)
	}

	dec := newDecoder(reader)

	msg, err := dec.Decode()
	if err != nil {
		t.Fatalf("Decoded did not return an error%s", err)
	}

	var recv Msg1
	err = msg.Decode(&recv)

	// ToDo :fix
	if err != nil {
		t.Fatalf("Decoded did not return an error %s", err)
	}
}

func TestDecodeBogus(t *testing.T) {

	reader := new(bytes.Buffer)
	dec := newDecoder(reader)

	reader.Write([]byte("bogus data"))

	msg, err := dec.Decode()
	if err == nil {
		t.Fatalf("Decoded did not return an error")
	}

	//Bogus struc decode
	type bogusStruct struct {
		field1 string
	}

	reader = new(bytes.Buffer)
	enc := newEncoder(reader)

	err = enc.Encode(from, to, mtype, nil)
	if err != nil {
		t.Fatalf("Error encoding message %s", err)
	}

	dec = newDecoder(reader)
	msg, err = dec.Decode()

	var decval bogusStruct
	err = msg.Decode(&decval)
	if err == nil {
		t.Fatalf("Decoded did not return an error")
	}

}
